/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * 委譲先に委譲する{@link Map}。
 * 
 * @author nakamura
 * 
 */
public class DelegationMap<K, V> implements Map<K, V> {
	private final Map<K, V> child;

	/**
	 * コンストラクタ。
	 * 
	 * @param child
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public DelegationMap(final Map<K, V> child) {
		CheckUtils.checkNotNull(child);
		this.child = child;
	}

	public void clear() {
		child.clear();
	}

	public boolean containsKey(final Object key) {
		return child.containsKey(key);
	}

	public boolean containsValue(final Object value) {
		return child.containsValue(value);
	}

	public Set<Entry<K, V>> entrySet() {
		return child.entrySet();
	}

	public V get(final Object key) {
		return child.get(key);
	}

	public boolean isEmpty() {
		return child.isEmpty();
	}

	public Set<K> keySet() {
		return child.keySet();
	}

	public V put(final K key, final V value) {
		return child.put(key, value);
	}

	public void putAll(final Map<? extends K, ? extends V> t) {
		child.putAll(t);
	}

	public int size() {
		return child.size();
	}

	public Collection<V> values() {
		return child.values();
	}

	public V remove(final Object key) {
		return child.remove(key);
	}

	@Override
	public boolean equals(final Object o) {
		return child.equals(o);
	}

	@Override
	public int hashCode() {
		return child.hashCode();
	}

	@Override
	public String toString() {
		return child.toString();
	}
}
