/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Set;

/**
 * 委譲先に委譲する{@link Set}。
 * 
 * @author nakamura
 * 
 */
public class DelegationSet<T> extends
DelegationCollection<T> implements Set<T> {

	/**
	 * コンストラクタ。
	 * 
	 * @param child
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public DelegationSet(final Set<T> child) {
		super(child);
	}
}
