/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import javax.xml.transform.Result;
import javax.xml.transform.Source;

/**
 * {@link javax.xml.transform.Transformer#transform(Source, Result)}
 * を取り出したインタフェース。
 * {@link javax.xml.transform}パッケージの実装が同時に動作する複数のスレッドで使用することを保証していないため、
 * 同時に動作する複数のスレッドで使用することを保証するラッパーを作成する目的で定義している。
 * 
 * @author nakamura
 * 
 */
public interface XmlTransformer {
	/**
	 * XML Source を Result に変換する。
	 * 
	 * @param xmlSource
	 *            変換する XML 入力。
	 * @param outputTarget
	 *            xmlSource の変換の Result。
	 */
	void transform(final Source xmlSource, final Result outputTarget);
}
