/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

/**
 * {@link XmlTransformer}のファクトリ。
 * {@link javax.xml.transform}パッケージの実装が同時に動作する
 * 複数のスレッドで使用することを保証していないため、
 * 同時に動作する複数のスレッドで使用することを保証するラッパーを作成する目的で定義している。
 * 適用しているパターン：Abstract Factory。
 * 
 * @author nakamura
 * 
 */
public interface XmlTransformerFactory {
	/**
	 * {@link XmlTransformer}を返す。
	 * 
	 * @return {@link XmlTransformer}のインスタンス。
	 */
	XmlTransformer newInstance();
}
