/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

/**
 * {@link ValidatorContext#getTmpValue()}
 * にデフォルト値を設定して true を返す{@link ValidatorExpression}。
 * 
 * @author nakamura
 * 
 */
public class DefaultValueValidator implements ValidatorExpression {
	private final Object value;

	/**
	 * コンストラクタ。
	 * 
	 * @param value
	 *            デフォルト値。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public DefaultValueValidator(final Object value) {
		this.value = value;
	}

	/**
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public boolean interpret(final ValidatorContext context) {
		context.setTmpValue(value);
		return true;
	}

	public Object getValue() {
		return value;
	}
}
