/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

/**
 * {@link Visitor}を受け入れることが可能であることを表す。 オリジナルの Visitor デザインパターンでは Element 役に
 * accept メソッドを定義しているが、 本設計では Element 役から accept メソッドを分離することが可能。
 * 適用しているパターン：Visitor。
 * 
 * @author nakamura
 * 
 * @param <V>
 *            Element 役。実装クラスで型キャストを不要にしコンパイラに型キャストを行わせるための宣言。
 */
public interface Acceptable<V> {
	/**
	 * {@link Visitor#visit(Object)}から呼び出される(called)。 実装クラスでは v を解析する必要がある。
	 * また必要に応じて v が保持するプロパティの処理に関するを visitor に委譲する。
	 * 
	 * @param visitor
	 *            訪問者。
	 * @param v
	 *            Element 役。
	 */
	void accept(Visitor visitor, V v);
}
