/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.adapter.NodeFindableLoadTest;
import woolpack.dom.CacheNodeLoadTest;
import woolpack.dom.JoinProcessLoadTest;
import woolpack.ee.DoAcquireTransactionLoadTest;
import woolpack.html.UpdateValueLoadTest;
import woolpack.utils.XmlTransformerFactoryTest;

public class LoadAllTests extends TestCase {

	public static final int MAX_CONCURRENT = 2;

	public static final int MAX_THREAD = 5;

	public static final int TEST_COUNT = 2000;

	public static final int TEST_THRESHOLD = 200;

	public static final ExecutorService THREAD_POOL = Executors
			.newFixedThreadPool(LoadAllTests.MAX_THREAD);

	public static Test suite() {
		final TestSuite suite = new TestSuite();

		suite.addTest(new TestSuite(CacheNodeLoadTest.class));
		suite.addTest(new TestSuite(JoinProcessLoadTest.class));

		suite.addTest(new TestSuite(UpdateValueLoadTest.class));
		suite.addTest(new TestSuite(DoAcquireTransactionLoadTest.class));

		suite.addTest(new TestSuite(XmlTransformerFactoryTest.class));
		suite.addTest(new TestSuite(NodeFindableLoadTest.class));

		return suite;
	}
}
