/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.action;

import junit.framework.TestCase;

public class ForwardMatcherTest extends TestCase {

	public void testGet() {
		final Object object = new Object();
		final ForwardMatcher matcher = new ForwardMatcher(object);
		assertEquals(object, matcher.getReturnedObject());
	}

	public void testObject() {
		final ForwardMatcher matcher = new ForwardMatcher("a");
		assertFalse(matcher.matches(null));
		assertTrue(matcher.matches("a"));
		assertFalse(matcher.matches("b"));
		assertFalse(matcher.matches(new Exception()));
		assertFalse(matcher.matches(new RuntimeException()));
		assertFalse(matcher.matches(new IndexOutOfBoundsException()));
		assertFalse(matcher.matches(new ArrayIndexOutOfBoundsException()));
	}

	public void testNull() {
		final ForwardMatcher matcher = new ForwardMatcher(null);
		assertTrue(matcher.matches(null));
		assertFalse(matcher.matches("a"));
		assertFalse(matcher.matches("b"));
		assertFalse(matcher.matches(new Exception()));
		assertFalse(matcher.matches(new RuntimeException()));
		assertFalse(matcher.matches(new IndexOutOfBoundsException()));
		assertFalse(matcher.matches(new ArrayIndexOutOfBoundsException()));
	}

	public void testClass() {
		final ForwardMatcher matcher = new ForwardMatcher(
				IndexOutOfBoundsException.class);
		assertFalse(matcher.matches(null));
		assertFalse(matcher.matches("a"));
		assertFalse(matcher.matches("b"));
		assertFalse(matcher.matches(new Exception()));
		assertFalse(matcher.matches(new RuntimeException()));
		assertTrue(matcher.matches(new IndexOutOfBoundsException()));
		assertTrue(matcher.matches(new ArrayIndexOutOfBoundsException()));
	}
}
