/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CrudAllTests extends TestCase {

	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(CrudConstantsTest.class));
		suite.addTest(new TestSuite(FixUpdaterTest.class));
		suite.addTest(new TestSuite(InputMapPointerTest.class));
		suite.addTest(new TestSuite(PreparedStatementExecutorTest.class));
		suite.addTest(new TestSuite(QueryFactoryCacheImplTest.class));
		suite.addTest(new TestSuite(UpdatableFactoryCacheImplTest.class));
		suite.addTest(new TestSuite(QueryFactoryImplTest.class));
		suite.addTest(new TestSuite(UpdatableFactoryImplTest.class));
		return suite;
	}
	
	static TableInfo getTableInfo() {
		final TableInfo tableInfo = new TableInfo();
		tableInfo.setName("my_table");
		tableInfo.getColumnCollection().add("my_id");
		tableInfo.getColumnCollection().add("my_seq");
		tableInfo.getColumnCollection().add("my_string");
		tableInfo.getColumnCollection().add("my_int");
		tableInfo.getPrimaryKeyCollection().add("my_id");
		tableInfo.getPrimaryKeyCollection().add("my_seq");
		return tableInfo;
	}
}
