/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import javax.sql.DataSource;

import woolpack.adapter.HSQLDBConstants;

import junit.framework.TestCase;

public class PreparedStatementExecutorTest extends TestCase {
	public void testException() {
		try {
			final DataSource dataSource = HSQLDBConstants.getMemoryDataSource("mydb_PreparedStatementExecutorTest");
			final Executable executor = new PreparedStatementExecutor(dataSource);
			
			//final Map<String, List<Object>> map = null;
			final Expression expression = new Expression();
			expression.setQuery("hoge");
			expression.setInputMapPointerList(new ArrayList<InputMapPointer>());
			executor.execute(expression, new Fetchable() {
				public void fetch(final Statement statement) {
					throw new IllegalStateException(new SQLException());
				}
			}, null);
			fail();
		} catch (final IllegalStateException e) {
			assertTrue(e.getCause() instanceof SQLException);
		}
	}
}
