/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import woolpack.adapter.HSQLDBConstants;

import junit.framework.TestCase;

public class UpdatableFactoryCacheImplTest extends TestCase {
	public void testNoCache() {
		final DataSource dataSource = HSQLDBConstants.getMemoryDataSource("mydb1_QueryFactoryCacheImplTest0");

		final TableInfo info = CrudAllTests.getTableInfo();
		final Map<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>();
		tableInfoMap.put("myTable", info);
		
		final UpdatableFactory factory = new UpdatableFactoryCacheImpl(
				null,
				new UpdatableFactoryImpl(
						new ExpressionFactoryImpl(tableInfoMap, CrudConstants.INSERT),
						new PreparedStatementExecutor(dataSource)
				)
		);

		final Map<String, List<Object>> map = new HashMap<String, List<Object>>();
		map.put("myId", Arrays.asList((Object)"myId0"));
		map.put("mySeq", Arrays.asList((Object)"mySeq0"));
		map.put("myString", Arrays.asList((Object)"myString0"));
		map.put("myInt", Arrays.asList((Object)"myInt0"));
		
		assertNotSame(factory.newInstance("myTable", map), factory.newInstance("myTable", map));
	}

	public void testCache() {
		final DataSource dataSource = HSQLDBConstants.getMemoryDataSource("mydb1_QueryFactoryCacheImplTest0");

		final TableInfo info = CrudAllTests.getTableInfo();
		final Map<String, TableInfo> tableInfoMap = new HashMap<String, TableInfo>();
		tableInfoMap.put("myTable", info);
		
		final UpdatableFactory factory = new UpdatableFactoryCacheImpl(
				new HashMap<Object, Updatable>(),
				new UpdatableFactoryImpl(
						new ExpressionFactoryImpl(tableInfoMap, CrudConstants.INSERT),
						new PreparedStatementExecutor(dataSource)
				)
		);

		final Map<String, List<Object>> map = new HashMap<String, List<Object>>();
		map.put("myId", Arrays.asList((Object)"myId0"));
		map.put("mySeq", Arrays.asList((Object)"mySeq0"));
		map.put("myString", Arrays.asList((Object)"myString0"));
		map.put("myInt", Arrays.asList((Object)"myInt0"));
		assertSame(factory.newInstance("myTable", map), factory.newInstance("myTable", map));
		{
			final Map<String, List<Object>> map1 = new HashMap<String, List<Object>>();
			map1.put("myId", Arrays.asList((Object)"myId0"));
			map1.put("mySeq", Arrays.asList((Object)"mySeq0"));
			map1.put("myString", Arrays.asList((Object)"myString0"));
			map1.put("myInt", Arrays.asList((Object)"myInt1"));
			assertSame(factory.newInstance("myTable", map), factory.newInstance("myTable", map1));
		}
		{
			final Map<String, List<Object>> map1 = new HashMap<String, List<Object>>();
			map1.put("myId", Arrays.asList((Object)"myId0"));
			map1.put("mySeq", Arrays.asList((Object)"mySeq0"));
			assertNotSame(factory.newInstance("myTable", map), factory.newInstance("myTable", map1));
		}
	}
}
