/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Arrays;

import junit.framework.TestCase;
import woolpack.adapter.JXP;
import woolpack.el.FixEL;
import woolpack.test.TestUtils;
import woolpack.utils.FixSwitch;
import woolpack.utils.SwitchBuilder;

public class BranchByAttrValueTest extends TestCase {

	public void testConstructor() {
		try {
			new BranchByAttrValue(null, new FixSwitch<String, DomExpression>(
					null));
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new BranchByAttrValue(Arrays.asList("action", "href"), null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final DomExpression expression = new Serial(TestUtils
				.getToNodeBody("<A href=\"page0.html\" >page0</A>"
						+ "<A href=\"page1.html\" >page1</A>"
						+ "<A href=\"page2.html\" >page2</A>"
						+ "<A href=\"page3.html\" >page3</A>"), new XPath(
				new JXP("//A"), new BranchByAttrValue(Arrays.asList("href"),
						new SwitchBuilder<String, DomExpression>().put(
								"page0.html",
								new UpdateAttrValue("href", new FixEL(
										"page0.do"))).put(
								"page1.html",
								new UpdateAttrValue("href", new FixEL(
										"page1.do"))).put(
								"page2.html",
								new UpdateAttrValue("href", new FixEL(
										"page2.do"))).get(
								new UpdateAttrValue("href", new FixEL(
										"pagee.do"))))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsBody(context,
				"<A href=\"page0.do\" >page0</A>"
						+ "<A href=\"page1.do\" >page1</A>"
						+ "<A href=\"page2.do\" >page2</A>"
						+ "<A href=\"pagee.do\" >page3</A>"));
	}

	public void testNotOther() {
		final DomExpression expression = new Serial(TestUtils
				.getToNodeBody("<A href=\"page0.html\" >page0</A>"
						+ "<A href=\"page1.html\" >page1</A>"
						+ "<A href=\"page2.html\" >page2</A>"
						+ "<A href=\"page3.html\" >page3</A>"), new XPath(
				new JXP("//A"), new BranchByAttrValue(Arrays.asList("href"),
						new SwitchBuilder<String, DomExpression>().put(
								"page0.html",
								new UpdateAttrValue("href", new FixEL(
										"page0.do"))).put(
								"page1.html",
								new UpdateAttrValue("href", new FixEL(
										"page1.do"))).put(
								"page2.html",
								new UpdateAttrValue("href", new FixEL(
										"page2.do"))).get())));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsBody(context,
				"<A href=\"page0.do\" >page0</A>"
						+ "<A href=\"page1.do\" >page1</A>"
						+ "<A href=\"page2.do\" >page2</A>"
						+ "<A href=\"page3.html\" >page3</A>"));
	}
}
