/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * 
 * @author nakamura
 * 
 */
public class DomAllTests extends TestCase {
	public static Test suite() {
		final TestSuite suite = new TestSuite();

		suite.addTest(new TestSuite(BranchButtonTest.class));
		suite.addTest(new TestSuite(BranchTest.class));
		suite.addTest(new TestSuite(BranchByAttrValueTest.class));
		suite.addTest(new TestSuite(CacheNodeTest.class));
		suite.addTest(new TestSuite(DumpIfCatchTest.class));
		suite.addTest(new TestSuite(FormatAttrValueTest.class));
		suite.addTest(new TestSuite(ResetIdTest.class));
		suite.addTest(new TestSuite(CountTest.class));
		suite.addTest(new TestSuite(DelegateDomExpressionTest.class));
		suite.addTest(new TestSuite(DoAcquireTest.class));
		suite.addTest(new TestSuite(DoAcquireSessionTest.class));
		suite.addTest(new TestSuite(DoELTest.class));
		suite.addTest(new TestSuite(DomConstantsTest.class));
		suite.addTest(new TestSuite(DomContextTest.class));
		suite.addTest(new TestSuite(EvalAttrValueContainsTest.class));
		suite.addTest(new TestSuite(EvalELTest.class));
		suite.addTest(new TestSuite(EvalIdContainsTest.class));
		suite.addTest(new TestSuite(EvalIdRegExpTest.class));
		suite.addTest(new TestSuite(EvalNetMaskTest.class));
		suite.addTest(new TestSuite(FormatIdTest.class));
		suite.addTest(new TestSuite(IfTest.class));
		suite.addTest(new TestSuite(InsertElementToChildTest.class));
		suite.addTest(new TestSuite(InsertElementToParentTest.class));
		suite.addTest(new TestSuite(JoinProcessTest.class));
		suite.addTest(new TestSuite(LoopTest.class));
		suite.addTest(new TestSuite(MeasureLapTimeTest.class));
		suite.addTest(new TestSuite(NodeLoopTest.class));
		suite.addTest(new TestSuite(NodeLoopDelegateTest.class));
		suite.addTest(new TestSuite(RemoveAttrTest.class));
		suite.addTest(new TestSuite(ReplaceTextToChildTest.class));
		suite.addTest(new TestSuite(ReplaceTextTest.class));
		suite.addTest(new TestSuite(SaveInputForBackTest.class));
		suite.addTest(new TestSuite(SerialTest.class));
		suite.addTest(new TestSuite(SleepTest.class));
		suite.addTest(new TestSuite(UpdateAttrValueTest.class));
		suite.addTest(new TestSuite(XmlToNodeTest.class));
		suite.addTest(new TestSuite(XPathAttrValueTest.class));
		suite.addTest(new TestSuite(XPathTest.class));

		return suite;
	}
}
