/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.adapter.JXP;
import woolpack.el.ELConstants;
import woolpack.el.FixEL;
import woolpack.test.TestUtils;
import woolpack.utils.SwitchBuilder;

public class EvalAttrValueContainsTest extends TestCase {

	public void testConstructor() {
		try {
			new EvalAttrValueContains(null, ELConstants.NULL);
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new EvalAttrValueContains("", ELConstants.NULL);
			fail();
		} catch (final StringIndexOutOfBoundsException expected) {
		}
		try {
			new EvalAttrValueContains("a", null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testTrueExpression() {
		final DomExpression expression = new Serial(
				TestUtils
						.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
				new XPath(new JXP("name", "name0"),
						new If(new EvalAttrValueContains("value", new FixEL(
								"value0")), new UpdateAttrValue("value",
								new FixEL("newValue1")), new UpdateAttrValue(
								"value", new FixEL("newValue2")))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context,
				"<INPUT type=\"text\" name=\"name0\" value=\"newValue1\" />"));
	}

	public void testFalseExpression() {
		final DomExpression expression = new Serial(
				TestUtils
						.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
				new XPath(new JXP("name", "name0"),
						new If(new EvalAttrValueContains("value", new FixEL(
								"value1")), new UpdateAttrValue("value",
								new FixEL("newValue1")), new UpdateAttrValue(
								"value", new FixEL("newValue2")))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context,
				"<INPUT type=\"text\" name=\"name0\" value=\"newValue2\" />"));
	}

	public void testNotFalseExpression() {
		final DomExpression expression = new Serial(
				TestUtils
						.getToNodeForm("<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"),
				new XPath(
						new JXP("name", "name0"),
						new Branch<Boolean>(
								new EvalAttrValueContains("value", new FixEL(
										"value1")),
								new SwitchBuilder<Boolean, DomExpression>()
										.put(
												Boolean.TRUE,
												new UpdateAttrValue("value",
														new FixEL("newValue1")))
										.get())));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equalsForm(context,
				"<INPUT type=\"text\" name=\"name0\" value=\"value0\" />"));
	}
}
