/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Map;

import junit.framework.TestCase;
import woolpack.el.AbstractToELTargetExceptionEL;
import woolpack.el.ELConstants;

public class EvalELTest extends TestCase {

	public void testConstructor() {
		try {
			new EvalEL("a", null);
			fail();
		} catch (final NullPointerException expected) {
		}
		new EvalEL(null, ELConstants.NULL);
	}

	public void testNormal() {
		final EvalEL eval = new EvalEL("prefix_", new AbstractToELTargetExceptionEL() {
			@Override
			public Object execute(final Object root, final Object value) throws Exception {
				final Map map = (Map) root;
				return map.get("resource")
						+ ((DomContext) map.get("context")).getId();
			}
		});
		final DomContext context = new DomContext();

		context.setId("id0");
		assertEquals("prefix_id0", eval.eval(context));

		context.setId("id1");
		assertEquals("prefix_id1", eval.eval(context));

		context.setId(null);
		assertEquals("prefix_null", eval.eval(context));
	}
}
