/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.Arrays;

import junit.framework.TestCase;

public class EvalIdContainsTest extends TestCase {

	public void testConstructor() {
		try {
			new EvalIdContains(null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final Evaluable<Boolean> eval = new EvalIdContains(Arrays.asList("id0",
				"id1"));
		final DomContext context = new DomContext();

		context.setId("id2");
		assertEquals(Boolean.FALSE, eval.eval(context));

		context.setId("id1");
		assertEquals(Boolean.TRUE, eval.eval(context));
	}
}
