/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;
import woolpack.adapter.JXP;
import woolpack.el.FixEL;
import woolpack.test.TestUtils;

public class InsertElementToParentTest extends TestCase {

	public void testConstructor() {
		try {
			new InsertElementToParent(null, DomConstants.NULL);
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new InsertElementToParent("", DomConstants.NULL);
			fail();
		} catch (final StringIndexOutOfBoundsException expected) {
		}
		try {
			new InsertElementToParent("FORM", null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final DomExpression expression = new Serial(
				TestUtils
						.getToNodeBody("<SPAN id=\"id0\" >hoge0<SPAN id=\"id1\" >hoge1<SPAN id=\"id2\" >value0</SPAN>piyo1</SPAN>piyo0</SPAN>"),
				new XPath(new JXP("id", "id1"), new InsertElementToParent(
						"FORM", new UpdateAttrValue("action", new FixEL(
								"action0")))));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils
				.equalsBody(
						context,
						"<SPAN id=\"id0\" >hoge0<FORM action=\"action0\"><SPAN id=\"id1\" >hoge1<SPAN id=\"id2\" >value0</SPAN>piyo1</SPAN></FORM>piyo0</SPAN>"));
	}

	public void testNotExpression() {
		final DomExpression expression = new Serial(
				TestUtils
						.getToNodeBody("<SPAN id=\"id0\" >hoge0<SPAN id=\"id1\" >hoge1<SPAN id=\"id2\" >value0</SPAN>piyo1</SPAN>piyo0</SPAN>"),
				new XPath(new JXP("id", "id1"), new InsertElementToParent(
						"FORM")));
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils
				.equalsBody(
						context,
						"<SPAN id=\"id0\" >hoge0<FORM><SPAN id=\"id1\" >hoge1<SPAN id=\"id2\" >value0</SPAN>piyo1</SPAN></FORM>piyo0</SPAN>"));
	}
}
