/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import junit.framework.TestCase;

public class MeasureLapTimeTest extends TestCase {
	private long time;

	private DomContext context;

	public void testNormal() {
		final DomExpression expression = new MeasureLapTime(new Sleep(100, 0,
				DomConstants.NULL)) {
			@Override
			public void recode(final DomContext context, final long time) {
				MeasureLapTimeTest.this.context = context;
				MeasureLapTimeTest.this.time = time;
				super.recode(context, time);
			}
		};

		final DomContext context = new DomContext();
		expression.interpret(context);
		assertTrue(this.context == context);
		assertTrue(Math.abs(time - 100) < 10);
	}
}
