/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;
import woolpack.el.convert.ConvertConstants;

public class MapELTest extends TestCase {

	public void testConstructor() {
		try {
			new MapEL(null, ConvertConstants.COLLECTION_CONVERTER);
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new MapEL("", ConvertConstants.COLLECTION_CONVERTER);
			fail();
		} catch (final StringIndexOutOfBoundsException expected) {
		}
		try {
			new MapEL("key0", null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}
}
