/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.utils.MapBuilder;

public class PathELTest extends TestCase {

	public void testConstructor() {
		try {
			new PathEL(null, ELConstants.PROPERTY_EL_FACTORY);
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new PathEL("key0", null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormalMap() {
		final Map<String, Object> map = MapBuilder.get(
				new HashMap<String, Object>()).put(
				"key0",
				MapBuilder.get(new HashMap<String, Object>()).put("key1",
						Integer.valueOf(3)).get()).get();

		final EL el = new PathEL("key0.key1", ELConstants.PROPERTY_EL_FACTORY);

		assertEquals(Integer.valueOf(3), el.getValue(map));
		assertEquals("3", el.getValue(map, String.class));

		el.setValue(map, "valuee01a");
		assertEquals("valuee01a", el.getValue(map));
	}
}
