/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import java.util.Arrays;
import java.util.Collection;

import junit.framework.TestCase;

import woolpack.test.TestUtils;

public class CollectionConverterTest extends TestCase {

	public void testConstructor() {
		try {
			new CollectionConverter(null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final Convertable c = new CollectionConverter(
				ConvertConstants.SIMPLE_CONVERTER);
		assertTrue(TestUtils.equals("1", c.convert("1", Object.class, null)));
		assertTrue(TestUtils.equals(Integer.valueOf(1), c.convert("1",
				Integer.class, null)));
		assertTrue(TestUtils.equals(new int[] { 1 }, c.convert("1",
				int[].class, null)));
		assertTrue(TestUtils.equals(new Integer[] { Integer.valueOf(1) }, c
				.convert("1", Integer[].class, null)));
		assertTrue(TestUtils.equals(Arrays.asList("1"), c.convert("1",
				Collection.class, null)));

		assertTrue(TestUtils.equals(new String[] { "1" }, c.convert(
				new String[] { "1" }, Object.class, null)));
		assertTrue(TestUtils.equals(Integer.valueOf(1), c.convert(
				new String[] { "1" }, Integer.class, null)));
		assertTrue(TestUtils.equals(new int[] { 1 }, c.convert(
				new String[] { "1" }, int[].class, null)));
		assertTrue(TestUtils.equals(new Integer[] { Integer.valueOf(1) }, c
				.convert(new String[] { "1" }, Integer[].class, null)));
		assertTrue(TestUtils.equals(Arrays.asList("1"), c.convert(
				new String[] { "1" }, Collection.class, null)));

		assertTrue(TestUtils.equals("1", c.convert(Arrays.asList("1"),
				Object.class, null)));
		assertTrue(TestUtils.equals(Integer.valueOf(1), c.convert(Arrays
				.asList("1"), Integer.class, null)));
		assertTrue(TestUtils.equals(new int[] { 1 }, c.convert(Arrays
				.asList("1"), int[].class, null)));
		assertTrue(TestUtils.equals(new Integer[] { Integer.valueOf(1) }, c
				.convert(Arrays.asList("1"), Integer[].class, null)));
		assertTrue(TestUtils.equals(Arrays.asList("1"), c.convert(Arrays
				.asList("1"), Collection.class, null)));

		assertNull(c.convert(null, Object.class, null));
		assertNull(c.convert(null, Integer.class, null));
		assertTrue(TestUtils.equals(new int[] { 0 }, c.convert(null,
				int[].class, null)));
		assertTrue(TestUtils.equals(new Integer[] { null }, c.convert(null,
				Integer[].class, null)));
		assertTrue(TestUtils.equals(Arrays.asList((Object) null), c.convert(
				null, Collection.class, null)));
	}
}
