/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ConvertAllTests extends TestCase {

	public static Test suite() {
		final TestSuite suite = new TestSuite();

		suite.addTest(new TestSuite(CollectionConverterTest.class));
		suite.addTest(new TestSuite(ConvertConstantsTest.class));
		suite.addTest(new TestSuite(DelegationIfNecessityConverterTest.class));
		suite.addTest(new TestSuite(FixConverterTest.class));
		suite.addTest(new TestSuite(FormatConverterTest.class));
		suite.addTest(new TestSuite(NumberConverterTest.class));
		suite.addTest(new TestSuite(ParseConverterTest.class));
		suite.addTest(new TestSuite(SerialConverterTest.class));
		suite.addTest(new TestSuite(SimpleConverterTest.class));
		suite.addTest(new TestSuite(ToTypeToWapperConverterTest.class));
		suite.addTest(new TestSuite(ValidatorConverterTest.class));

		return suite;
	}
}
