/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el.convert;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;

import junit.framework.TestCase;
import woolpack.text.FormatFactory;

public class ParseConverterTest extends TestCase {

	public void testConstructor() {
		try {
			new ParseConverter((FormatFactory) null);
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new ParseConverter((Format) null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final Convertable c = new ParseConverter(new DecimalFormat());

		assertEquals(Long.valueOf(1000L), c.convert("1000", null, null));

		try {
			c.convert("a", null, null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(e.getCause() instanceof ParseException);
		}

		try {
			c.convert("", null, null);
			fail();
		} catch (final IllegalArgumentException e) {
			assertTrue(e.getCause() instanceof ParseException);
		}

		try {
			c.convert(Integer.valueOf(1), null, null);
			fail();
		} catch (final ClassCastException e) {
		}

		try {
			c.convert(null, null, null);
			fail();
		} catch (final NullPointerException e) {
		}
	}
}
