/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.Locale;

import junit.framework.TestCase;
import woolpack.utils.FixSwitch;
import woolpack.utils.SwitchBuilder;
import woolpack.validator.CountValidator;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;

public class BranchByLocaleValidatorTest extends TestCase {

	public void testConstructor() {
		try {
			new BranchByLocaleValidator(null, new ThreadLocal<Locale>());
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new BranchByLocaleValidator(
					new FixSwitch<Locale, ValidatorExpression>(null), null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final CountValidator counter0 = new CountValidator(
				ValidatorConstants.FALSE);
		final CountValidator counter1 = new CountValidator(
				ValidatorConstants.TRUE);
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final ValidatorExpression expression = new BranchByLocaleValidator(
				new SwitchBuilder<Locale, ValidatorExpression>().put(
						Locale.JAPANESE, counter0)
						.put(Locale.ENGLISH, counter1).get(), threadLocal);
		final ValidatorContext context = new ValidatorContext();

		threadLocal.set(Locale.JAPANESE);
		assertFalse(expression.interpret(context));
		assertEquals(1, counter0.getCount());
		assertEquals(0, counter1.getCount());

		threadLocal.set(Locale.ENGLISH);
		assertTrue(expression.interpret(context));
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
	}
}
