/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.Locale;

import junit.framework.TestCase;
import woolpack.utils.SwitchBuilder;
import woolpack.utils.Switchable;

public class LocaleConstantsTest extends TestCase {

	public void testNearLocaleSwitch() {
		{
			final Switchable<Locale, String> switchable = LocaleConstants
					.nearLocaleSwitch(new SwitchBuilder<Locale, String>().put(
							Locale.ENGLISH, "e").put(Locale.JAPANESE, "j").get(
							"d"));
			assertEquals("e", switchable.get(Locale.ENGLISH));
			assertEquals("e", switchable.get(Locale.US));
			assertEquals("j", switchable.get(Locale.JAPANESE));
			assertEquals("j", switchable.get(Locale.JAPAN));
			assertEquals("d", switchable.get(Locale.CHINESE));
			assertEquals("d", switchable.get(null));
		}
		{
			final Switchable<Locale, String> switchable = LocaleConstants
					.nearLocaleSwitch(new SwitchBuilder<Locale, String>().put(
							Locale.ENGLISH, "e").put(Locale.JAPANESE, "j").put(
							new Locale("ja", "JP", "POSIX"), "p").get("d"));
			assertEquals("e", switchable.get(Locale.ENGLISH));
			assertEquals("e", switchable.get(Locale.US));
			assertEquals("j", switchable.get(Locale.JAPANESE));
			assertEquals("j", switchable.get(Locale.JAPAN));
			assertEquals("d", switchable.get(Locale.CHINESE));
			assertEquals("d", switchable.get(null));
			assertEquals("p", switchable.get(new Locale("ja", "JP", "POSIX")));
		}
		{
			final Switchable<Locale, String> switchable = LocaleConstants
					.nearLocaleSwitch(new SwitchBuilder<Locale, String>().put(
							Locale.JAPAN, "japan").put(Locale.JAPANESE,
							"japanese").put(new Locale("ja", "JP", "POSIX"),
							"p").get("d"));
			assertEquals("p", switchable.get(new Locale("ja", "JP", "POSIX")));
			assertEquals("japan", switchable.get(new Locale("ja", "JP", "WIN")));
			assertEquals("japan", switchable.get(new Locale("ja", "JP")));
			assertEquals("japanese", switchable.get(new Locale("ja")));
			// assertEquals("japanese", switchable.get(new Locale("ja", "US")));
			assertEquals("d", switchable.get(new Locale("en")));
		}
		{
			final Switchable<Locale, String> switchable = LocaleConstants
					.nearLocaleSwitch(new SwitchBuilder<Locale, String>().put(
							Locale.US, "e").put(Locale.JAPAN, "j").get("d"));
			assertEquals("d", switchable.get(Locale.ENGLISH));
			assertEquals("e", switchable.get(Locale.US));
			assertEquals("d", switchable.get(Locale.JAPANESE));
			assertEquals("j", switchable.get(Locale.JAPAN));
			assertEquals("d", switchable.get(Locale.CHINESE));
			assertEquals("d", switchable.get(null));
		}
		{
			final Switchable<Locale, String> switchable0 = new SwitchBuilder<Locale, String>()
					.put(Locale.US, "e").put(Locale.JAPAN, "j").get("d");
			final Switchable<Locale, String> switchable1 = LocaleConstants
					.nearLocaleSwitch(switchable0);
			assertEquals(switchable0.getDefault(), switchable1.getDefault());
			assertEquals(switchable0.keys(), switchable1.keys());
		}
	}
}
