/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.HashMap;
import java.util.Locale;

import junit.framework.TestCase;
import woolpack.config.ConfigContext;
import woolpack.config.ConfigExpression;

public class LocalePutResourceBundleTest extends TestCase {

	public void testConstructor() {
		try {
			new LocalePutResourceBundle(null, new ThreadLocal<Locale>());
			fail();
		} catch (final NullPointerException expected) {
		}
		try {
			new LocalePutResourceBundle("", new ThreadLocal<Locale>());
			fail();
		} catch (final StringIndexOutOfBoundsException expected) {
		}
		try {
			new LocalePutResourceBundle("a", null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() {
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final ConfigExpression expression = new LocalePutResourceBundle(
				"woolpack.locale.ResourceBundle2MapTest", threadLocal);
		{
			threadLocal.set(Locale.JAPANESE);
			final ConfigContext context = new ConfigContext();
			context.setMap(new HashMap<String, Object>());
			expression.interpret(context);
			assertEquals("value_ja0", context.getMap().get("key0"));
		}
		{
			threadLocal.set(Locale.ENGLISH);
			final ConfigContext context = new ConfigContext();
			context.setMap(new HashMap<String, Object>());
			expression.interpret(context);
			assertEquals("value_en0", context.getMap().get("key0"));
		}
		{
			threadLocal.set(null);
			final ConfigContext context = new ConfigContext();
			context.setMap(new HashMap<String, Object>());
			expression.interpret(context);
			assertEquals("value1", context.getMap().get("key1"));
		}
	}
}
