/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

public class BranchInputStreamFactoryTest extends TestCase {

	public void testConstructor() {
		try {
			new BranchInputStreamFactory(null);
			fail();
		} catch (final NullPointerException expected) {
		}
	}

	public void testNormal() throws IOException {
		final InputStreamFactory factory = new BranchInputStreamFactory(
				new SwitchBuilder<String, InputStreamFactory>().put("id0",
						new StringInputStreamFactory("US-ASCII", "value0"))
						.put(
								"id1",
								new StringInputStreamFactory("US-ASCII",
										"value1")).get(
								new StringInputStreamFactory("US-ASCII",
										"valuen")));
		{
			final StringBuilder sb = new StringBuilder();
			final InputStream stream = factory.newInstance("id0");
			int i = 0;
			while ((i = stream.read()) >= 0) {
				sb.append((char) i);
			}
			assertEquals("value0", sb.toString());
		}
		{
			final StringBuilder sb = new StringBuilder();
			final InputStream stream = factory.newInstance("id1");
			int i = 0;
			while ((i = stream.read()) >= 0) {
				sb.append((char) i);
			}
			assertEquals("value1", sb.toString());
		}
		{
			final StringBuilder sb = new StringBuilder();
			final InputStream stream = factory.newInstance(null);
			int i = 0;
			while ((i = stream.read()) >= 0) {
				sb.append((char) i);
			}
			assertEquals("valuen", sb.toString());
		}
	}
}
