/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils.concurrent;

import java.util.Arrays;
import java.util.concurrent.Semaphore;

import junit.framework.TestCase;
import woolpack.LoadAllTests;
import woolpack.test.RunnableGate;
import woolpack.test.RunnableGate.Context;
import woolpack.test.TestUtils;

public class DoSemaphoreTest extends TestCase {

	public void testConstructor() {
		try {
			new DoSemaphore(null);
			fail();
		} catch (final NullPointerException e) {
		}
	}

	public void testNormal() {
		final Semaphore semaphore = new Semaphore(1);
		final Acquirable acquirable = new DoSemaphore(semaphore);

		final RunnableGate gate = new RunnableGate(LoadAllTests.THREAD_POOL);
		final Runnable runnable = new Runnable() {
			public void run() {
				if (acquirable.acquire()) {
					try {
						gate.getPause("pause", "resume").run();
					} finally {
						acquirable.release();
					}
				} else {
					gate.getGate("false").run();
				}
			}
		};

		final Context context0 = gate.execute(runnable);
		assertTrue(context0.waitFor("pause"));
		assertFalse(context0.waitFor("resume"));

		final Context context1 = gate.execute(runnable);
		assertTrue(context1.waitForStart());
		assertFalse(context1.waitFor("pause"));

		{
			final Context context2 = gate.execute(runnable);
			assertTrue(context2.waitForStart());
			assertFalse(context2.waitFor("pause"));
			context2.getThread().interrupt();
			assertTrue(TestUtils.equals(Arrays.asList(), context2.getEndList()));
		}

		context0.resume();
		assertTrue(TestUtils.equals(Arrays.asList("pause", "resume"), context0
				.getEndList()));

		assertTrue(context1.waitFor("pause"));
		assertFalse(context1.waitFor("resume"));

		context1.resume();
		assertTrue(TestUtils.equals(Arrays.asList("pause", "resume"), context1
				.getEndList()));
	}
}
