/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import junit.framework.TestCase;
import woolpack.test.TestUtils;
import woolpack.utils.MapBuilder;

public class MaxValidatorTest extends TestCase {

	public void testNormal() {
		final ValidatorExpression expression = new MaxValidator(2);
		final ValidatorContext context = new ValidatorContext();
		context.setInputMap(new HashMap<String, List<Object>>());
		context.setTmpKey("key0");

		context.setTmpValue(Integer.valueOf(1));
		assertTrue(expression.interpret(context));
		assertTrue(TestUtils.equals(MapBuilder.get(
				new HashMap<String, Object>()).put("key0", Arrays.asList(1))
				.get(), context.getInputMap()));

		context.setTmpValue(Integer.valueOf(2));
		assertTrue(expression.interpret(context));
		assertTrue(TestUtils.equals(MapBuilder.get(
				new HashMap<String, Object>()).put("key0", Arrays.asList(2))
				.get(), context.getInputMap()));

		context.setTmpValue(Integer.valueOf(3));
		assertFalse(expression.interpret(context));
		assertTrue(TestUtils.equals(MapBuilder.get(
				new HashMap<String, Object>()).put("key0", Arrays.asList(3))
				.get(), context.getInputMap()));

		try {
			context.setTmpValue("1");
			expression.interpret(context);
			fail();
		} catch (final ClassCastException e) {
			assertTrue(TestUtils.equals(MapBuilder.get(
					new HashMap<String, Object>()).put("key0",
					Arrays.asList("1")).get(), context.getInputMap()));
		}

		try {
			context.setTmpValue(null);
			expression.interpret(context);
			fail();
		} catch (final NullPointerException e) {
			assertTrue(TestUtils.equals(MapBuilder.get(
					new HashMap<String, Object>()).put("key0",
					Arrays.asList((Object) null)).get(), context.getInputMap()));
		}
	}
}
