/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ValidatorAllTests extends TestCase {

	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(AddressedMessageCollectorTest.class));
		suite.addTest(new TestSuite(AddressedMessageTest.class));
		suite.addTest(new TestSuite(BranchByIdValidatorTest.class));
		suite.addTest(new TestSuite(BranchByNameValidatorTest.class));
		suite.addTest(new TestSuite(BranchByNameIfExistsValidatorTest.class));
		suite.addTest(new TestSuite(CountValidatorTest.class));
		suite.addTest(new TestSuite(DumpValidatorTest.class));
		suite.addTest(new TestSuite(EqualsValidatorTest.class));
		suite.addTest(new TestSuite(FormatValidatorTest.class));
		suite.addTest(new TestSuite(IfNotValidatorTest.class));
		suite.addTest(new TestSuite(IfValidatorTest.class));
		suite.addTest(new TestSuite(MaxLengthValidatorTest.class));
		suite.addTest(new TestSuite(MaxValidatorTest.class));
		suite.addTest(new TestSuite(MessageValidatorTest.class));
		suite.addTest(new TestSuite(MinLengthValidatorTest.class));
		suite.addTest(new TestSuite(MinValidatorTest.class));
		suite.addTest(new TestSuite(NotValidatorTest.class));
		suite.addTest(new TestSuite(DefaultValueValidatorTest.class));
		suite.addTest(new TestSuite(ParseValidatorTest.class));
		suite.addTest(new TestSuite(RegExpIdValidatorTest.class));
		suite.addTest(new TestSuite(RegExpValidatorTest.class));
		suite.addTest(new TestSuite(RetainNamesValidatorTest.class));
		suite.addTest(new TestSuite(SerialValidatorTest.class));
		suite.addTest(new TestSuite(SimpleMessageCollectorTest.class));
		suite.addTest(new TestSuite(TmpIndexValidatorTest.class));
		suite.addTest(new TestSuite(TmpKeyValidatorTest.class));
		suite.addTest(new TestSuite(ValidatorConstantsTest.class));
		suite.addTest(new TestSuite(ValidatorContextTest.class));
		suite.addTest(new TestSuite(ValidNamesValidatorTest.class));
		suite.addTest(new TestSuite(ValidValuesValidatorTest.class));
		suite.addTest(new TestSuite(ValueLoopValidatorTest.class));
		return suite;
	}
}
