/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

import java.util.LinkedHashMap;

import junit.framework.TestCase;
import woolpack.utils.MapBuilder;
import woolpack.utils.SwitchBuilder;
import woolpack.utils.Switchable;
import woolpack.validator.ValidatorConstants;

public class JsVisitorConstantsTest extends TestCase {

	public void testGetLocalClassName() {
		assertEquals("ValidatorConstants", JsVisitorConstants
				.getLocalClassName(ValidatorConstants.class));
	}

	public void testSwitchable() {
		final Visitor visitor = new Visitor();
		visitor
				.setMap(MapBuilder
						.get(new LinkedHashMap<Object, Acceptable>())
						.put(
								Switchable.class,
								JsVisitorConstants
										.switchableAcceptable("defaultKey"))
						.put(
								Object.class,
								JsVisitorConstants
										.escapeStringAcceptable(JsVisitorConstants.OBJECT))
						.get());
		final StringBuilder sb = new StringBuilder();
		visitor.setContext(sb);
		visitor.visit(new SwitchBuilder<Object, Object>().get("defaultValue"));
		assertEquals("{\"defaultKey\":\"defaultValue\"}", sb.toString());

		sb.setLength(0);
		visitor.visit(new SwitchBuilder<Object, Object>().put("key0", "value0")
				.get("defaultValue"));
		assertEquals("{\"key0\":\"value0\",\"defaultKey\":\"defaultValue\"}",
				sb.toString());
	}

}
