/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.test.TestUtils;
import woolpack.utils.MapBuilder;

public class VisitorTest extends TestCase {
	public void testObject() {
		final CountAcceptor<Object> counter0 = new CountAcceptor<Object>();
		final CountAcceptor<Object> counter1 = new CountAcceptor<Object>();
		final Visitor visitor = new Visitor();
		visitor.setMap(MapBuilder.get(new LinkedHashMap<Object, Acceptable>())
				.put("key0", counter0).put("key1", counter1).get());

		visitor.visit("key0");
		assertTrue(TestUtils.equals(Arrays.asList("key0"), counter0.getList()));
		assertEquals(0, counter1.getList().size());

		visitor.visit("key1");
		assertTrue(TestUtils.equals(Arrays.asList("key0"), counter0.getList()));
		assertTrue(TestUtils.equals(Arrays.asList("key1"), counter1.getList()));
	}

	public void testClass() {
		final CountAcceptor<Object> counter0 = new CountAcceptor<Object>();
		final CountAcceptor<Object> counter1 = new CountAcceptor<Object>();
		final Visitor visitor = new Visitor();
		visitor.setMap(MapBuilder.get(new LinkedHashMap<Object, Acceptable>())
				.put("key0", VisitorConstants.NULL).put(String.class, counter0)
				.put(Integer.class, counter1).get());

		visitor.visit("key1");
		assertTrue(TestUtils.equals(Arrays.asList("key1"), counter0.getList()));
		assertEquals(0, counter1.getList().size());

		visitor.visit(Integer.valueOf(3));
		assertTrue(TestUtils.equals(Arrays.asList("key1"), counter0.getList()));
		assertTrue(TestUtils.equals(Arrays.asList(Integer.valueOf(3)), counter1
				.getList()));

		visitor.visit(new Double(3));
		assertTrue(TestUtils.equals(Arrays.asList("key1"), counter0.getList()));
		assertTrue(TestUtils.equals(Arrays.asList(Integer.valueOf(3)), counter1
				.getList()));
	}

	public void testNull() {
		final CountAcceptor<Object> counter0 = new CountAcceptor<Object>();
		final Visitor visitor = new Visitor();
		final Map<Object, Acceptable> map = MapBuilder.get(
				new LinkedHashMap<Object, Acceptable>()).put(Object.class,
				counter0).get();
		visitor.setMap(map);
		assertSame(map, visitor.getMap());

		visitor.visit(null);
		assertTrue(TestUtils
				.equals(Collections.emptyList(), counter0.getList()));
	}
}
