/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor.impl;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;

import junit.framework.TestCase;
import woolpack.dom.DomContext;
import woolpack.test.TestUtils;
import woolpack.text.ToIntegerFormat;
import woolpack.text.ToSQLDateFormat;
import woolpack.utils.MapBuilder;
import woolpack.visitor.Acceptable;
import woolpack.visitor.DomVisitorConstants;
import woolpack.visitor.Visitor;

public class DocBaseConstantsTest extends TestCase {

	private void scenario(final Object expression, final String expected) {
		final DomContext context = new DomContext();
		TestUtils.getToNode("<HTML><BODY></BODY></HTML>").interpret(context);
		final Visitor visitor = new Visitor();
		visitor.setMap(MapBuilder.get(new LinkedHashMap<Object, Acceptable>())
				.putAll(DocBaseConstants.BASE).put(Object.class,
						DomVisitorConstants.OBJECT).get());
		visitor.setContext(context.getNode().getFirstChild().getFirstChild());
		visitor.visit(expression);
		assertTrue(TestUtils.equalsBody(context, expected));
	}

	public void testSimpleDateFormat() {
		scenario(new SimpleDateFormat("yyyyMMdd"), "パターン\"yyyyMMdd\"の日付フォーマット");
	}

	public void testDecimalFormat() {
		scenario(new DecimalFormat(), "パターン\"#,##0.###\"の数値フォーマット");
	}

	public void testDateFormat() {
		scenario(new ToSQLDateFormat(new SimpleDateFormat("yyyyMMdd")),
				"日付変換フォーマット");
	}

	public void testNumberFormat() {
		scenario(new ToIntegerFormat(), "数値変換フォーマット");
	}
}
