/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import woolpack.crud.Query;
import woolpack.crud.QueryFactory;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFactoryCacheImpl
implements QueryFactory {
    private final Map<Object, Query> cacheMap;
    private final QueryFactory factory;

    public QueryFactoryCacheImpl(Map<Object, Query> cacheMap, QueryFactory factory) {
        CheckUtils.checkNotNull(factory);
        this.cacheMap = cacheMap;
        this.factory = factory;
    }

    @Override
    public Query newInstance(String id, Map<String, List<Object>> map) {
        if (this.cacheMap == null) {
            return this.factory.newInstance(id, map);
        }
        HashMap<String, Object> key = new HashMap<String, Object>(2);
        key.put("name", id);
        key.put("columnSet", map.keySet());
        Query query = this.cacheMap.get(key);
        if (query == null) {
            query = this.factory.newInstance(id, map);
            this.cacheMap.put(key, query);
        }
        return query;
    }
}

