/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import woolpack.el.AbstractEL;
import woolpack.el.ELConstants;
import woolpack.el.PropertyELFactory;
import woolpack.utils.CheckUtils;

public class PropertyEL
extends AbstractEL {
    private final String propertyName;
    private final PropertyELFactory factory;

    public PropertyEL(String propertyName, PropertyELFactory factory) {
        CheckUtils.checkNotEmpty(propertyName);
        CheckUtils.checkNotNull(factory);
        this.propertyName = propertyName;
        this.factory = factory;
    }

    public PropertyEL(String propertyName) {
        this(propertyName, ELConstants.PROPERTY_EL_FACTORY);
    }

    public Object getValue(Object root, Class clazz) {
        return this.factory.newGetter(root.getClass(), this.propertyName).getValue(root, clazz);
    }

    public void setValue(Object root, Object value) {
        this.factory.newSetter(root.getClass(), this.propertyName).setValue(root, value);
    }

    public PropertyELFactory getFactory() {
        return this.factory;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

