/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.util.HashMap;
import java.util.Map;
import woolpack.el.convert.Convertable;
import woolpack.utils.CheckUtils;
import woolpack.utils.MapBuilder;

public class ToTypeToWapperConverter
implements Convertable {
    private static final Map<Class, Class> PRIMITIVE_TO_WRAPPER_MAP = MapBuilder.get(new HashMap()).put(Boolean.TYPE, Boolean.class).put(Character.TYPE, Character.class).put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).get();
    private final Convertable convertable;

    public ToTypeToWapperConverter(Convertable convertable) {
        CheckUtils.checkNotNull(convertable);
        this.convertable = convertable;
    }

    public Object convert(Object beforeValue, Class toType, String propertyName) {
        Class newClass = PRIMITIVE_TO_WRAPPER_MAP.get(toType);
        if (newClass == null) {
            newClass = toType;
        }
        return this.convertable.convert(beforeValue, newClass, propertyName);
    }

    public Convertable getConvertable() {
        return this.convertable;
    }
}

