/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Element;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.el.GettingEL;
import woolpack.utils.CheckUtils;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenAllToChild
implements DomExpression {
    private final GettingEL mapEL;
    private final Collection<String> excludeProperties;

    public HiddenAllToChild(GettingEL mapEL, Collection<String> excludeProperties) {
        CheckUtils.checkNotNull(mapEL);
        CheckUtils.checkNotNull(excludeProperties);
        this.mapEL = mapEL;
        this.excludeProperties = excludeProperties;
    }

    @Override
    public void interpret(DomContext context) {
        Map map = (Map)this.mapEL.getValue(context);
        for (Map.Entry entryObject : map.entrySet()) {
            Map.Entry entry = entryObject;
            if (this.excludeProperties.contains(entry.getKey())) continue;
            Iterable values = UtilsConstants.toIterable(entry.getValue());
            for (Object value : values) {
                Element e = DomConstants.getDocumentNode(context.getNode()).createElement("INPUT");
                e.setAttribute("type", "hidden");
                e.setAttribute("name", entry.getKey().toString());
                e.setAttribute("value", value.toString());
                context.getNode().appendChild(e);
            }
        }
    }
}

