/*
 * Decompiled with CFR 0.152.
 */
package woolpack.test;

import java.io.PrintStream;

public class TestConcurrent {
    private final String label;
    private final Object lock;
    private final int minConcurrent;
    private final int maxConcurrent;
    private final int threshold;
    private final double failOdds;
    private final int[] concurrentArray;
    private final int[] threadArray;
    private final ThreadLocal<Integer> threadLocal;
    private int currentConcurrent;
    private int count;
    private boolean minValidFlag;
    private boolean maxValidFlag;

    public TestConcurrent(String label, Object lock, int minConcurrent, int maxConcurrent, int threadCount, int threshold) {
        this(label, lock, minConcurrent, maxConcurrent, threadCount, threshold, 0.5);
    }

    public TestConcurrent(String label, Object lock, int minConcurrent, int maxConcurrent, int threadCount, int threshold, double failOdds) {
        this.label = label;
        this.lock = lock;
        this.minConcurrent = minConcurrent;
        this.maxConcurrent = maxConcurrent;
        this.threshold = threshold;
        this.failOdds = failOdds;
        this.concurrentArray = new int[maxConcurrent + 2];
        this.threadArray = new int[threadCount];
        this.threadLocal = new ThreadLocal();
        this.currentConcurrent = 0;
        this.count = 0;
        this.minValidFlag = true;
        this.maxValidFlag = true;
    }

    public int getCount() {
        return this.count;
    }

    public void setThreadId(int i) {
        this.threadLocal.set(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recodeThread() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.threadLocal.get();
            this.threadArray[n] = this.threadArray[n] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recodeConcurrent() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.currentConcurrent - 1;
            this.concurrentArray[n] = this.concurrentArray[n] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseConcurrent() {
        Object object = this.lock;
        synchronized (object) {
            ++this.currentConcurrent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseConcurrent() {
        Object object = this.lock;
        synchronized (object) {
            --this.currentConcurrent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        Object object = this.lock;
        synchronized (object) {
            this.minValidFlag &= this.minConcurrent <= this.currentConcurrent;
            this.maxValidFlag &= this.currentConcurrent <= this.maxConcurrent;
        }
    }

    private void failRandom() {
        if (Math.random() < this.failOdds) {
            throw new IllegalStateException("random fail.");
        }
    }

    public void execute() {
        Thread.yield();
        this.increaseCount();
        Thread.yield();
        this.recodeThread();
        Thread.yield();
        this.increaseConcurrent();
        Thread.yield();
        this.recodeConcurrent();
        Thread.yield();
        this.check();
        Thread.yield();
        this.decreaseConcurrent();
        Thread.yield();
        this.failRandom();
        Thread.yield();
    }

    public void print() {
        PrintStream stream = System.out;
        stream.print(this.label);
        stream.print(" : ");
        if (this.count == 0) {
            stream.print("count:0");
        } else {
            stream.print("thread");
            this.print(this.threadArray);
            stream.print(", ");
            stream.print("mean : ");
            stream.print(this.culcMean(this.threadArray));
            stream.print(", ");
            stream.print("concurrent");
            this.print(this.concurrentArray);
            stream.print(", ");
            stream.print("min : ");
            stream.print(this.minValidFlag);
            stream.print(", ");
            stream.print("max : ");
            stream.print(this.maxValidFlag);
        }
        stream.println();
    }

    public boolean assertValid() {
        boolean result;
        boolean bl = result = this.minValidFlag && this.maxValidFlag && this.assertThreshold(this.threadArray);
        if (!result) {
            PrintStream stream = System.out;
            stream.println("minValid : ");
            stream.println(this.minValidFlag);
            stream.println("maxValid : ");
            stream.println(this.maxValidFlag);
            stream.println("threshold : ");
            stream.println(this.assertThreshold(this.threadArray));
            this.print();
        }
        return result;
    }

    private void print(int[] array) {
        PrintStream stream = System.out;
        int i = 0;
        while (i < array.length) {
            stream.print("-");
            stream.print(array[i]);
            ++i;
        }
    }

    private int culcMean(int[] array) {
        if (array.length == 0) {
            return 0;
        }
        int mean = 0;
        int i = 0;
        while (i < array.length) {
            mean += array[i];
            ++i;
        }
        return mean /= array.length;
    }

    private boolean assertThreshold(int[] array) {
        int mean = this.culcMean(array);
        int i = 0;
        while (i < array.length) {
            if (Math.abs(mean - array[i]) > this.threshold) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

