/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.frame;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import woolpack.adapter.JXP;
import woolpack.adapter.JXPFactory;
import woolpack.dom.DelegateDomExpression;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.DumpIfCatch;
import woolpack.dom.FormatAttrValue;
import woolpack.dom.FormatId;
import woolpack.dom.ResetId;
import woolpack.dom.Serial;
import woolpack.dom.XPath;
import woolpack.dom.XmlToNode;
import woolpack.ee.ServletInputStreamFactory;
import woolpack.html.FrameToTable;
import woolpack.html.HtmlConstants;
import woolpack.text.RegExpFormat;
import woolpack.utils.InputStreamReaderFactory;
import woolpack.utils.UtilsConstants;

/**
 * FRAME を TABLE に変換するサンプル Web アプリケーション。
 * @author nakamura
 *
 */
public class FrameServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public final transient DelegateDomExpression toNode;
	public final transient DomExpression domExpression;
	
	public FrameServlet() {
		super();
		toNode = new DelegateDomExpression();

		domExpression = new DumpIfCatch(new Serial(
				new FormatId(new RegExpFormat("^.*/([^/]+)$", "$1")),
				new FrameToTable("common_frame", "target", new Serial(
						toNode,
						HtmlConstants.NORMALIZE_CASE,
						new XPath(new JXP("//A[@href]"), new FormatAttrValue("href", new RegExpFormat("^([^\\.]+)\\.[^\\.]+$", "$1"))),
						new XPath(new JXP("//FORM[@action]"), new FormatAttrValue("action", new RegExpFormat("^([^\\.]+)\\.[^\\.]+$", "$1"))),
						new XPath(new JXP("//FRAME[@src]"), new FormatAttrValue("src", new RegExpFormat("^([^\\.]+)\\.[^\\.]+$", "$1")))
				), new JXPFactory())
		));
	}


	@Override public void init(final ServletConfig servletConfig) throws ServletException {
		super.init(servletConfig);
		toNode.setExpression(new ResetId(new Serial(
				new FormatId(new RegExpFormat("^(.*)$", "/html/sample/frame/$1.html")),
				new XmlToNode(new InputStreamReaderFactory(new ServletInputStreamFactory(servletConfig.getServletContext()), "UTF-8")))));
	}

	@Override protected void service(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
		final DomContext domContext = new DomContext();
		domContext.setId(request.getRequestURI());
//		domContext.setInput(EEConstants.convert(request.getParameterMap()));
//		domContext.setRequest(new ServletRequestAttributeMap(request));
//		domContext.setSession(new HttpSessionMap(request.getSession()));
//		domContext.setApplication(new ServletContextMap(request.getSession().getServletContext()));
		domExpression.interpret(domContext);
		final Writer w = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8"));
		try {
			UtilsConstants.TRANSFORMER_FACTORY.newInstance().transform(
					new DOMSource(domContext.getNode()),
					new StreamResult(w)
			);
		} finally {
			w.close();
		}
	}
}
