/*
 * Decompiled with CFR 0.152.
 */
package woolpack.sql.adapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DriverManagerDataSource
implements DataSource {
    private String className;
    private String url;
    private String user;
    private String password;
    private boolean anonymousConnectFlag;

    public DriverManagerDataSource(String className, String url, String user, String password, boolean anonymousConnectFlag) {
        this.className = className;
        this.url = url;
        this.user = user;
        this.password = password;
        this.anonymousConnectFlag = anonymousConnectFlag;
    }

    public DriverManagerDataSource(String className, String url, String user, String password) {
        this(className, url, user, password, false);
    }

    public DriverManagerDataSource(String className, String url) {
        this(className, url, null, null, true);
    }

    private void loadClass() throws SQLException {
        try {
            Class.forName(this.className);
        }
        catch (ClassNotFoundException e0) {
            SQLException e1 = new SQLException(e0.getMessage());
            e1.initCause(e0);
            throw e1;
        }
    }

    public Connection getConnection() throws SQLException {
        this.loadClass();
        if (this.anonymousConnectFlag) {
            return DriverManager.getConnection(this.url);
        }
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        this.loadClass();
        return DriverManager.getConnection(this.url, username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    public boolean isAnonymousConnectFlag() {
        return this.anonymousConnectFlag;
    }

    public void setAnonymousConnectFlag(boolean anonymousConnectFlag) {
        this.anonymousConnectFlag = anonymousConnectFlag;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

