/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.fn.Fn;
import woolpack.visitor.EchoAcceptor;
import woolpack.visitor.Visitor;
import woolpack.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementAcceptor<E extends Exception>
implements Fn<Visitor<Node, E>, Void, E> {
    private final String elementName;
    private final Fn<? super Visitor<Node, E>, Void, ? extends E> acceptor;

    public ElementAcceptor(String elementName, Fn<? super Visitor<Node, E>, Void, ? extends E> acceptor) {
        this.elementName = elementName;
        this.acceptor = acceptor;
    }

    public ElementAcceptor(String elementName) {
        this(elementName, new EchoAcceptor());
    }

    @Override
    public Void exec(Visitor<Node, E> visitor) throws E {
        Element node = (Element)visitor.getSubContext();
        Element element = XmlUtils.getDocumentNode(node).createElement(this.elementName);
        node.appendChild(element);
        Node baseContext = visitor.getSubContext();
        visitor.setSubContext(element);
        try {
            this.acceptor.exec(visitor);
        }
        finally {
            visitor.setSubContext(baseContext);
        }
        return null;
    }
}

