/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import java.text.Format;

import woolpack.fn.Fn;

/**
 * {@link Format#format(Object)}で変換する{@link Fn}です。
 * @author nakamura
 *
 * @param <E>
 */
public class FormatConverter<E extends Exception> implements Fn<Object, String, E> {
	private Fn<?, ? extends Format, ? extends E> formatFactory;
	
	public FormatConverter(final Fn<?, ? extends Format, ? extends E> formatFactory) {
		this.formatFactory = formatFactory;
	}

	public String exec(final Object c) throws E {
		return formatFactory.exec(null).format(c);
	}

	public Fn<?, ? extends Format, ? extends E> getFormatFactory() {
		return formatFactory;
	}
	public void setFormatFactory(final Fn<?, ? extends Format, ? extends E> formatFactory) {
		this.formatFactory = formatFactory;
	}
}
