/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.convert;

import java.util.Calendar;
import java.util.Date;

import woolpack.fn.Fn;

/**
 * 入力を{@link Date}にキャストして
 * {@link Calendar}に変換する{@link Fn}です。
 * @author nakamura
 *
 * @param <E>
 */
public class ToCalendarConverter<E extends Exception> implements Fn<Object, Calendar, E> {
	/**
	 * @throws ClassCastException 引数が{@link Date}でない場合。
	 */
	public Calendar exec(final Object c) {
		if (c instanceof Calendar) {
			return (Calendar) c;
		} else {
			final Calendar calendar = Calendar.getInstance();
			calendar.setTime((Date) c);
			return calendar;
		}
	}
}
