/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.id;

import woolpack.fn.Fn;

public class IdConverter<R, E extends Exception> implements Fn<IdContext, R, E> {
	private Fn<? super String, String, ? extends E> converter;
	
	public IdConverter(final Fn<? super String, String, ? extends E> converter) {
		this.converter = converter;
	}

	public R exec(final IdContext c) throws E {
		c.setId(converter.exec(c.getId()));
		return null;
	}

	public Fn<? super String, String, ? extends E> getConverter() {
		return converter;
	}
	public void setConverter(final Fn<? super String, String, ? extends E> fn) {
		this.converter = fn;
	}
}
