/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.adapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

/**
 * 委譲するだけの{@link Connection}です。
 * @author nakamura
 *
 */
public class ConnectionAdapter implements Connection {
	private Connection parent;
	
	public ConnectionAdapter(final Connection parent) {
		this.parent = parent;
	}
	public Connection getParent() {
		return parent;
	}
	public void setParent(final Connection parent) {
		this.parent = parent;
	}

	public void clearWarnings() throws SQLException {
		parent.clearWarnings();
	}

	public void close() throws SQLException {
		parent.close();
	}

	public void commit() throws SQLException {
		parent.commit();
	}

	public Statement createStatement() throws SQLException {
		return parent.createStatement();
	}

	public Statement createStatement(final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
		return parent.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	public Statement createStatement(final int resultSetType, final int resultSetConcurrency) throws SQLException {
		return parent.createStatement(resultSetType, resultSetConcurrency);
	}

	public boolean getAutoCommit() throws SQLException {
		return parent.getAutoCommit();
	}

	public String getCatalog() throws SQLException {
		return parent.getCatalog();
	}

	public int getHoldability() throws SQLException {
		return parent.getHoldability();
	}

	public DatabaseMetaData getMetaData() throws SQLException {
		return parent.getMetaData();
	}

	public int getTransactionIsolation() throws SQLException {
		return parent.getTransactionIsolation();
	}

	public Map<String, Class<?>> getTypeMap() throws SQLException {
		return parent.getTypeMap();
	}

	public SQLWarning getWarnings() throws SQLException {
		return parent.getWarnings();
	}

	public boolean isClosed() throws SQLException {
		return parent.isClosed();
	}

	public boolean isReadOnly() throws SQLException {
		return parent.isReadOnly();
	}

	public String nativeSQL(final String sql) throws SQLException {
		return parent.nativeSQL(sql);
	}

	public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
		return parent.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
		return parent.prepareCall(sql, resultSetType, resultSetConcurrency);
	}

	public CallableStatement prepareCall(final String sql) throws SQLException {
		return parent.prepareCall(sql);
	}

	public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
		return parent.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
	}

	public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
		return parent.prepareStatement(sql, resultSetType, resultSetConcurrency);
	}

	public PreparedStatement prepareStatement(final String sql, final int autoGeneratedKeys) throws SQLException {
		return parent.prepareStatement(sql, autoGeneratedKeys);
	}

	public PreparedStatement prepareStatement(final String sql, final int[] columnIndexes) throws SQLException {
		return parent.prepareStatement(sql, columnIndexes);
	}

	public PreparedStatement prepareStatement(final String sql, final String[] columnNames) throws SQLException {
		return parent.prepareStatement(sql, columnNames);
	}

	public PreparedStatement prepareStatement(final String sql) throws SQLException {
		return parent.prepareStatement(sql);
	}

	public void releaseSavepoint(final Savepoint savepoint) throws SQLException {
		parent.releaseSavepoint(savepoint);
	}

	public void rollback() throws SQLException {
		parent.rollback();
	}

	public void rollback(final Savepoint savepoint) throws SQLException {
		parent.rollback(savepoint);
	}

	public void setAutoCommit(final boolean autoCommit) throws SQLException {
		parent.setAutoCommit(autoCommit);
	}

	public void setCatalog(final String catalog) throws SQLException {
		parent.setCatalog(catalog);
	}

	public void setHoldability(final int holdability) throws SQLException {
		parent.setHoldability(holdability);
	}

	public void setReadOnly(final boolean readOnly) throws SQLException {
		parent.setReadOnly(readOnly);
	}

	public Savepoint setSavepoint() throws SQLException {
		return parent.setSavepoint();
	}

	public Savepoint setSavepoint(final String name) throws SQLException {
		return parent.setSavepoint(name);
	}

	public void setTransactionIsolation(final int level) throws SQLException {
		parent.setTransactionIsolation(level);
	}

	public void setTypeMap(final Map<String, Class<?>> map) throws SQLException {
		parent.setTypeMap(map);
	}
}
