/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.sql.meta;

import java.util.List;
import java.util.Map;

/**
 * テーブルの情報です。
 * @author nakamura
 *
 */
public class TableInfo {
	private String tableCatalog;
	private String tableSchema;
	private String tableName;
	private List<String> colNameList;
	private List<String> pkNameList;
	private Map<String, ColumnInfo> columnInfoMap;
	private List<ReferenceInfo> importedKeysList;
	private List<ReferenceInfo> exportedKeysList;
	
	public TableInfo(
			final String tableCatalog,
			final String tableSchema,
			final String tableName,
			final List<String> colNameList,
			final List<String> pkNameList,
			final Map<String, ColumnInfo> columnInfoMap,
			final List<ReferenceInfo> importedKeysList,
			final List<ReferenceInfo> exportedKeysList) {
		this.colNameList = colNameList;
		this.columnInfoMap = columnInfoMap;
		this.pkNameList = pkNameList;
		this.tableName = tableName;
		this.tableSchema = tableSchema;
		this.tableCatalog = tableCatalog;
		this.exportedKeysList = exportedKeysList;
		this.importedKeysList = importedKeysList;
	}
	
	public TableInfo() {
	}
	
	public List<String> getColNameList() {
		return colNameList;
	}
	public void setColNameList(final List<String> colNameList) {
		this.colNameList = colNameList;
	}
	public Map<String, ColumnInfo> getColumnInfoMap() {
		return columnInfoMap;
	}
	public void setColumnInfoMap(final Map<String, ColumnInfo> columnInfoMap) {
		this.columnInfoMap = columnInfoMap;
	}
	public List<String> getPkNameList() {
		return pkNameList;
	}
	public void setPkNameList(final List<String> pkNameList) {
		this.pkNameList = pkNameList;
	}
	public String getTableName() {
		return tableName;
	}
	public void setTableName(final String tableName) {
		this.tableName = tableName;
	}
	public String getTableSchema() {
		return tableSchema;
	}
	public void setTableSchema(final String tableSchema) {
		this.tableSchema = tableSchema;
	}
	public String getTableCatalog() {
		return tableCatalog;
	}
	public void setTableCatalog(final String tableCatalog) {
		this.tableCatalog = tableCatalog;
	}
	public List<ReferenceInfo> getExportedKeysList() {
		return exportedKeysList;
	}
	public void setExportedKeysList(final List<ReferenceInfo> exportedKeysList) {
		this.exportedKeysList = exportedKeysList;
	}
	public List<ReferenceInfo> getImportedKeysList() {
		return importedKeysList;
	}
	public void setImportedKeysList(final List<ReferenceInfo> importedKeysList) {
		this.importedKeysList = importedKeysList;
	}
}
