/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import woolpack.fn.Fn;

/**
 * オブジェクトを変換するための情報を表すコンテキストです。
 * <br/>適用しているデザインパターン：Interpreter(Context 役), Double Dispatch。
 * 
 * @author nakamura
 *
 */
public class ConvertContext {
	private Object value;
	private Class toType;
	private String propertyName;
	private Fn<ConvertContext, Void, RuntimeException> fn;
	
	public String getPropertyName() {
		return propertyName;
	}
	public void setPropertyName(final String propertyName) {
		this.propertyName = propertyName;
	}
	public Class getToType() {
		return toType;
	}
	public void setToType(final Class toType) {
		this.toType = toType;
	}
	public Object getValue() {
		return value;
	}
	public void setValue(final Object value) {
		this.value = value;
	}
	public Fn<ConvertContext, Void, RuntimeException> getFn() {
		return fn;
	}
	public void setFn(final Fn<ConvertContext, Void, RuntimeException> fn) {
		this.fn = fn;
	}
}
