/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.typeconvert;

import java.util.Iterator;

import woolpack.fn.Delegator;
import woolpack.fn.Fn;
import woolpack.utils.Utils;

/**
 * 値が{@link Iterable}の場合はその最初の要素を変換するように委譲し、
 * 値が{@link Iterable}以外で null でない場合はそのまま委譲する関数です。
 * @author nakamura
 * 
 */
public class ToCollectionDecompositionConverter extends Delegator<ConvertContext, Void, RuntimeException> {

	/**
	 * @param fn 委譲先。
	 */
	public ToCollectionDecompositionConverter(
			final Fn<? super ConvertContext, Void, ? extends RuntimeException> fn) {
		super(fn);
	}

	@Override
	public Void exec(final ConvertContext c) {
		final Iterator<?> it = Utils.toIterable(c.getValue()).iterator();
		if (it.hasNext()) {
			final Object o = it.next();
			c.setValue(o);
			super.exec(c);
		}
		return null;
	}
}
