/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.visitor;

import java.beans.PropertyDescriptor;
import java.util.List;

import woolpack.fn.Fn;
import woolpack.utils.BeanUtils;

/**
 * エレメント役から順次取り出したプロパティの
 * 名前と値を引数にして{@link Visitor#visit(Object)}に委譲する関数です。
 * @author nakamura
 *
 * @param <E>
 */
public class BeanAcceptor<E extends Exception> implements Fn<Visitor<?, E>, Void, E> {
	public Void exec(final Visitor<?, E> visitor) throws E {
		final List<PropertyDescriptor> methodList =
			BeanUtils.getGetterList(visitor.getElement().getClass());
		for (final PropertyDescriptor property : methodList) {
			final Object value = BeanUtils.get(visitor.getElement(), property.getReadMethod());
			visitor.visit(property.getName());
			visitor.visit(value);
		}
		return null;
	}
}
