/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.idnode;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;

import org.w3c.dom.Node;

import woolpack.factory.FactoryUtils;
import woolpack.fn.Fn;
import woolpack.fn.FnUtils;
import woolpack.id.IdUtils;
import woolpack.xml.XmlTransformerUtils;
import woolpack.xml.XmlUtils;

public class IdNodeUtilsTest extends TestCase {
	public void testCache() throws Exception {
		final Map<String, Object> map = new HashMap<String, Object>();
		final Fn<SimpleIdNodeContext, Void, Exception> fn = IdNodeUtils.cache(map, XmlUtils.<SimpleIdNodeContext, Exception>setNode(
			FnUtils.join(IdUtils.GET_ID, XmlUtils.nodeFactory(
				FactoryUtils.stringReaderFactory("<HTML><BODY>hoge</BODY></HTML>"),
				XmlTransformerUtils.TRANSFORMER)
			)));
		final SimpleIdNodeContext c = new SimpleIdNodeContext();
		c.setId("id0");
		
		fn.exec(c);
		final Node node = c.getNode();
		assertSame(node, map.get("id0"));
		
		c.setNode(null);
		fn.exec(c);
		assertSame(node, c.getNode());
		assertSame(node, map.get("id0"));
		
		c.setId("id1");
		c.setNode(null);
		fn.exec(c);
		assertTrue(node != c.getNode());
	}
}
